using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.WebApplication
{
    public class ELearning_Ajax : Gemini.Core.WebApplication.Base.AjaxComponent
    {

        protected bool? _isCourseComplete = null;
        protected bool? _isCourseInRepeatMode = null;

        public ELearning_Ajax(Gemini.Core.WebApplication.Base.AjaxComponentParam AjaxRequestParams) : base(AjaxRequestParams) { }

        public override string Name
        {
            get { return "ELearning_Ajax"; }
        }

        public override long ClientID
        {
            get { return 0; }
        }

        public override bool IsXSLRender
        {
            get
            {
                //if (//FunctionName.Equals("getPage") ||
                //    //FunctionName.Equals("getExercise") ||
                //    //FunctionName.Equals("getFirstExerciseForStaticPage") ||
                //    //FunctionName.Equals("resolveExercise") ||
                //    //FunctionName.Equals("checkExercise") ||
                //    //FunctionName.Equals("getNextExercise") ||
                //    //FunctionName.Equals("getPreviousExercise") ||
                //    //FunctionName.Equals("getCourseMenu"))
                //{
                //    return false;
                //}

                return true;
            }
        }

        public override void Load()
        {
            base.Load();

            try
            {
                EnvironmentAjaxParam _environmentParam = new EnvironmentAjaxParam(this);

                PI.FM.N001.Account.BL.BO.User _user = Environment.User as PI.FM.N001.Account.BL.BO.User;
                if (_user != null)
                {
                    XML.Element.Start("User");
                    XML.Element.Attribute("CountLogin", _user.CountLogin);
                    XML.Element.Attribute("DateLastInvalidLogin", _user.DateLastInvalidLogin, Gemini.Utility.Normalize.DateTimeFormatType.Full);
                    XML.Element.Attribute("DateLastLogin", _user.DateLastLogin, Gemini.Utility.Normalize.DateTimeFormatType.Full);
                    XML.Element.End();
                }

                #region getNextExercise
                if (FunctionName.Equals("loadNextExercise"))
                {
                    LoadNextExercise(_environmentParam);
                }
                #endregion

                #region getPrevExercise
                if (FunctionName.Equals("loadPreviousExercise"))
                {
                    LoadPreviousExercise(_environmentParam);
                    return;
                }
                #endregion

                #region loadExercise
                if (FunctionName.Equals("loadExercise"))
                {
                    LoadExercise(_environmentParam);
                    return;
                }
                #endregion

                #region resolveExercise
                if (FunctionName.Equals("resolveExercise"))
                {
                    ResolveExercise(_environmentParam);
                    return;
                }
                #endregion

                #region checkExercise
                if (FunctionName.Equals("checkExercise"))
                {
                    CheckExercise(_environmentParam);
                    return;
                }
                #endregion

                #region loadCourseMenu
                if (FunctionName.Equals("loadCourseMenu"))
                {
                    GetMenu(_environmentParam);
                    return;
                }
                #endregion
            }

            catch (Exception _exception)
            {
                Gemini.Utility.Debug.SendExeptionViaEmali(Environment.ProjectName, _exception, String.Format("{0}{1}", Environment.Domain, Environment.URL));
            }
        }

        private PI.ZB.N1200.ELearning.BL.ZSBELearning _blZSBELearning = null;

        private PI.ZB.N1200.ELearning.BL.ZSBELearning BLZSBELearning
        {
            get
            {
                if (_blZSBELearning == null)
                {
                    _blZSBELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(Environment);
                }
                return _blZSBELearning;
            }
        }

        private void GetMenu(EnvironmentAjaxParam Param)
        {
            XmlDocument _xmlMenu = BLZSBELearning.BLELearning.Course.GetXMLMenu(Param.ContextParam.Course, Param.ContextParam.ContextObjectID, Param.ContextParam.Mode, WebPageEngine.IsUserAuthorized);

            XML.Element.WriteRawXML(_xmlMenu.DocumentElement.OuterXml);
        }

        private void LoadNextExercise(EnvironmentAjaxParam Param)
        {
            try
            {
                Param.ContextParam.ExerciseState = GM.N610.ELearning.BL.ELearning.ExerciseState.Load;
                Param.ContextParam = BLZSBELearning.Exercise.Navigation.RestoreNext(Param.ContextParam);

                LoadExercise(Param);
            }
            catch (Exception _exception)
            {
                Gemini.Utility.Debug.SendExeptionViaEmali(Environment.ProjectName, _exception, String.Format("{0}{1}", Environment.Domain, Environment.URL));
            }
        }

        private void LoadPreviousExercise(EnvironmentAjaxParam Param)
        {
            try
            {               
                Param.ContextParam.ExerciseState = GM.N610.ELearning.BL.ELearning.ExerciseState.Load;
                Param.ContextParam = BLZSBELearning.Exercise.Navigation.RestorePrevious(Param.ContextParam);
                LoadExercise(Param);
            }
            catch (Exception _exception)
            {
                Gemini.Utility.Debug.SendExeptionViaEmali(Environment.ProjectName, _exception, String.Format("{0}{1}", Environment.Domain, Environment.URL));
            }
        }

        private void LoadExercise(EnvironmentAjaxParam Param)
        {
            try
            {
                XmlDocument _xmlExercise = null;
                Param.ContextParam.ExerciseState = GM.N610.ELearning.BL.ELearning.ExerciseState.Load;

                if (Param.ContextParam.AuxyliaryPages == BL.Dictionary.AuxyliaryPagesType.None)
                {
                    if ((Param.ContextParam.IsCourseFinished) && (Param.ContextParam.CourseType != BL.Dictionary.Category.CourseType.CompetenceTheory))
                    {
                        _xmlExercise = BLZSBELearning.Exercise.Render.History(Param.ContextParam);
                        _xmlExercise = BLZSBELearning.Exercise.Render.BreadcrumbsMenu(Param.ContextParam, _xmlExercise);
                        _xmlExercise = BLZSBELearning.Exercise.Render.BreadcrumbsNavigation_History(Param.ContextParam, _xmlExercise);

                        _xmlExercise = BLZSBELearning.Avatar.Get(Param.ContextParam.ExerciseOut, _xmlExercise, GM.N610.ELearning.BL.Dictionary.Exercise.EventType.Check);
                    }
                    else
                    {
                        _xmlExercise = BLZSBELearning.Exercise.Render.Load(Param.ContextParam, WebPageEngine.IsUserAuthorized);                        
                        _xmlExercise = BLZSBELearning.Exercise.Render.BreadcrumbsMenu(Param.ContextParam, _xmlExercise);
                        _xmlExercise = BLZSBELearning.Exercise.Render.BreadcrumbsInfo(Param.ContextParam, _xmlExercise);
                        _xmlExercise = BLZSBELearning.Exercise.Render.BreadcrumbsNavigation(Param.ContextParam, _xmlExercise);

                        _xmlExercise = BLZSBELearning.Avatar.Get(Param.ContextParam.ExerciseOut, _xmlExercise, GM.N610.ELearning.BL.Dictionary.Exercise.EventType.Load);
                    }
                }
                else
                {
                    switch (Param.ContextParam.AuxyliaryPages)
                    {
                        case BL.Dictionary.AuxyliaryPagesType.CourseMenu:
                            _xmlExercise = BLZSBELearning.BLELearning.Course.GetXMLMenu(Param.ContextParam.Course, Param.ContextParam.ContextObjectID, Param.ContextParam.Mode, WebPageEngine.IsUserAuthorized);
                            break;
                        case BL.Dictionary.AuxyliaryPagesType.Summary:
                            _xmlExercise = BLZSBELearning.Exercise.Render.SummaryPage(Param.ContextParam);
                            break;
                        case BL.Dictionary.AuxyliaryPagesType.StartSummary:
                            _xmlExercise = BLZSBELearning.Exercise.Render.SummaryPage(Param.ContextParam);
                            _xmlExercise = BLZSBELearning.Exercise.Render.BreadcrumbsMenu(Param.ContextParam, _xmlExercise);
                            _xmlExercise = BLZSBELearning.Exercise.Render.BreadcrumbsNavigation_History(Param.ContextParam, _xmlExercise);
                            break;

                        case BL.Dictionary.AuxyliaryPagesType.NoAccess:
                            _xmlExercise = BLZSBELearning.Exercise.Render.NoAccess(Param.ContextParam);
                            break;
                        case BL.Dictionary.AuxyliaryPagesType.Error:
                            _xmlExercise = BLZSBELearning.Exercise.Render.Error(Param.ContextParam);
                            break;
                        case BL.Dictionary.AuxyliaryPagesType.Fraud:
                            _xmlExercise = BLZSBELearning.Exercise.Render.Fraud(Param.ContextParam);
                            break;
                        case BL.Dictionary.AuxyliaryPagesType.Redirect:
                            _xmlExercise = BLZSBELearning.Exercise.Render.Redirect(Param.ContextParam);
                            break;

                        default: break;
                    }
                }

                XML.Element.WriteRawXML(_xmlExercise.DocumentElement.OuterXml);
            }
            catch (Exception _exception)
            {
                Gemini.Utility.Debug.SendExeptionViaEmali(Environment.ProjectName, _exception, String.Format("{0}{1}", Environment.Domain, Environment.URL));
            }
        }

        private void ResolveExercise(EnvironmentAjaxParam Param)
        {
            try
            {
                XmlDocument _xmlExercise = null;

                if (!Param.ContextParam.IsExerciseAlreadyResolved)
                {
                    Param.ContextParam.ExerciseState = GM.N610.ELearning.BL.ELearning.ExerciseState.Resolve;

                    _xmlExercise = BLZSBELearning.Exercise.Render.Resolve(Param.ContextParam, AjaxRequestParams, WebPageEngine.IsUserAuthorized);
                    _xmlExercise = BLZSBELearning.Exercise.Render.BreadcrumbsMenu(Param.ContextParam, _xmlExercise);
                    _xmlExercise = BLZSBELearning.Exercise.Render.BreadcrumbsInfo(Param.ContextParam, _xmlExercise);
                    _xmlExercise = BLZSBELearning.Exercise.Render.BreadcrumbsNavigation(Param.ContextParam, _xmlExercise);

                    _xmlExercise = BLZSBELearning.Avatar.Get(Param.ContextParam.ExerciseOut, _xmlExercise, GM.N610.ELearning.BL.Dictionary.Exercise.EventType.Resolve);
                }
                else
                {
                    Param.ContextParam.AuxyliaryPages = BL.Dictionary.AuxyliaryPagesType.Fraud;
                    Param.ContextParam.ExerciseState = GM.N610.ELearning.BL.ELearning.ExerciseState.Load;

                    _xmlExercise = BLZSBELearning.Exercise.Render.Fraud(Param.ContextParam);
                    _xmlExercise = BLZSBELearning.Exercise.Render.BreadcrumbsMenu(Param.ContextParam, _xmlExercise);
                }
                XML.Element.WriteRawXML(_xmlExercise.DocumentElement.OuterXml);
            }
            catch (Exception _exception)
            {
                Gemini.Utility.Debug.SendExeptionViaEmali(Environment.ProjectName, _exception, String.Format("{0}{1}", Environment.Domain, Environment.URL));
            }
        }

        private void CheckExercise(EnvironmentAjaxParam Param)
        {
            try
            {
                XmlDocument _xmlExercise = null;

                if (!Param.ContextParam.IsExerciseAlreadyChecked)
                {
                    Param.ContextParam.ExerciseState = GM.N610.ELearning.BL.ELearning.ExerciseState.Check;

                    _xmlExercise = BLZSBELearning.Exercise.Render.Check(Param.ContextParam, AjaxRequestParams, WebPageEngine.IsUserAuthorized);
                    _xmlExercise = BLZSBELearning.Exercise.Render.BreadcrumbsMenu(Param.ContextParam, _xmlExercise);
                    _xmlExercise = BLZSBELearning.Exercise.Render.BreadcrumbsInfo(Param.ContextParam, _xmlExercise);
                    _xmlExercise = BLZSBELearning.Exercise.Render.BreadcrumbsNavigation(Param.ContextParam, _xmlExercise);

                    _xmlExercise = BLZSBELearning.Avatar.Get(Param.ContextParam.ExerciseOut, _xmlExercise, GM.N610.ELearning.BL.Dictionary.Exercise.EventType.Check);
                }
                else
                {
                    Param.ContextParam.ExerciseState = GM.N610.ELearning.BL.ELearning.ExerciseState.Load;

                    _xmlExercise = BLZSBELearning.Exercise.Render.Fraud(Param.ContextParam);
                    _xmlExercise = BLZSBELearning.Exercise.Render.BreadcrumbsMenu(Param.ContextParam, _xmlExercise);
                }

                XML.Element.WriteRawXML(_xmlExercise.DocumentElement.OuterXml);
            }
            catch (Exception _exception)
            {
                Gemini.Utility.Debug.SendExeptionViaEmali(Environment.ProjectName, _exception, String.Format("{0}{1}", Environment.Domain, Environment.URL));
            }
        }

        public class EnvironmentAjaxParam
        {            
            private BL.ZSBELearning.ContextParam _contextParam = null;

            public BL.ZSBELearning.ContextParam ContextParam
            {
                get
                {
                    return _contextParam;
                }

                set
                {
                    _contextParam = value;
                }
            }

            public EnvironmentAjaxParam(ELearning_Ajax ELearning_Ajax)
            {

                long? _courseID = Gemini.Utility.XML.Node.Get.Long(ELearning_Ajax.AjaxRequestParams.SelectSingleNode("CourseID"));
                long? _unitID = Gemini.Utility.XML.Node.Get.Long(ELearning_Ajax.AjaxRequestParams.SelectSingleNode("UnitID"));
                long? _exerciseID = Gemini.Utility.XML.Node.Get.Long(ELearning_Ajax.AjaxRequestParams.SelectSingleNode("ExerciseID"));
                long? _contextObjectID = Gemini.Utility.XML.Node.Get.Long(ELearning_Ajax.AjaxRequestParams.SelectSingleNode("ContextObjectID"));
                long? _statisticContextID = Gemini.Utility.XML.Node.Get.Long(ELearning_Ajax.AjaxRequestParams.SelectSingleNode("StatisticContextID"));
                int?  _modeID = Gemini.Utility.XML.Node.Get.Int(ELearning_Ajax.AjaxRequestParams.SelectSingleNode("ModeID"));

                _contextParam = new BL.ZSBELearning.ContextParam(ELearning_Ajax.BLZSBELearning, _contextObjectID, _courseID, _unitID, _exerciseID, _statisticContextID, _modeID);
            }
        }
    }
}
